(***********************************************
 *                                             *
 *              CS520 Fall 2006                *
 *           Programming Assignment            *
 *         Computer Science Department         *
 *             Boston University               *
 *                                             *
 ***********************************************)

(* Module Main: The main program. *)

open Format
open Support.Pervasive
open Support.Error
open Syntax
open Eval

let searchpath = ref [""]

let argDefs = [
  "-I",
  Arg.String (fun f -> searchpath := f::!searchpath),
  "Append a directory to the search path"]

let parseArgs () =
  let inFile = ref (None : string option) 
  in
    Arg.parse argDefs
      (fun s ->
        match !inFile with
          Some(_) -> err "You must specify exactly one input file"
	| None -> inFile := Some(s))
    "";
    match !inFile with
      None -> err "You must specify an input file"
    | Some(s) -> s

let openfile infile = 
  let rec trynext l = match l with
    [] -> err ("Could not find " ^ infile)
  | (d::rest) -> 
      let name = if d = "" then infile else (d ^ "/" ^ infile) in
      try open_in name
      with Sys_error m -> trynext rest
  in trynext !searchpath
    
let parseFile inFile =
  let pi = openfile inFile
  in let lexbuf = Lexer.create inFile pi
  in let result =
    try Parser.toplevel Lexer.main lexbuf with Parsing.Parse_error -> 
      error (Lexer.info lexbuf) "Parse error"
  in
    Parsing.clear_parser(); close_in pi; result
    
let main () = 
  let inFile = parseArgs() in
    let tm = parseFile inFile in
        let v = eval tm in
          printtm v

let res = 
  Printexc.catch (fun () -> 
    try main();0 
    with Exit x -> x) 
    ()

let () = print_flush()
let () = exit res
