/***********************************************
 *                                             *
 *              CS520 Fall 2006                *
 *           Programming Assignment            *
 *         Computer Science Department         *
 *             Boston University               *
 *                                             *
 ***********************************************/

/* Yacc grammar for the parser. */

%{
open Support.Error
open Support.Pervasive
open Syntax
%}

%token <string Support.Error.withinfo> VAR
%token <int Support.Error.withinfo> INTV
%token <string Support.Error.withinfo> STRINGV
%token EOF

/* Keyword tokens */
%token <Support.Error.info> LAMBDA /* lam */
%token <Support.Error.info> ELSE   /* else */
%token <Support.Error.info> FIX    /* fix */
%token <Support.Error.info> IF     /* if  */
%token <Support.Error.info> IN     /* in  */
%token <Support.Error.info> LAM    /* lam */
%token <Support.Error.info> LET    /* let */
%token <Support.Error.info> LETREC /* letrec */
%token <Support.Error.info> MOD    /* mod */
%token <Support.Error.info> PRINT  /* print */
%token <Support.Error.info> THEN   /* then */
%token <Support.Error.info> UNIT   /* unit */
%token <Support.Error.info> TRUE   /* true */
%token <Support.Error.info> FALSE  /* false */
%token <Support.Error.info> REF    /* ref */
%token <Support.Error.info> RAISE  /* raise */
%token <Support.Error.info> TRY    /* try */
%token <Support.Error.info> WITH   /* with */

/* Symbolic tokens */
%token <Support.Error.info> DARROW /* => */
%token <Support.Error.info> LPAREN /* ( */
%token <Support.Error.info> RPAREN /* ) */
%token <Support.Error.info> COLON  /* : */
%token <Support.Error.info> COMMA  /* , */
%token <Support.Error.info> DOT    /* . */
%token <Support.Error.info> EQ     /* = */
%token <Support.Error.info> ARROW  /* -> */
%token <Support.Error.info> BAR    /* | */

%token <Support.Error.info> TILDE  /* ~ */
%token <Support.Error.info> PLUS   /* + */
%token <Support.Error.info> MINUS  /* - */
%token <Support.Error.info> STAR   /* * */
%token <Support.Error.info> SLASH  /* / */
%token <Support.Error.info> BANG   /* ! */

%token <Support.Error.info> LT     /* < */
%token <Support.Error.info> LTEQ   /* <= */
%token <Support.Error.info> GT     /* > */
%token <Support.Error.info> GTEQ   /* >= */
%token <Support.Error.info> NEQ    /* <> */
%token <Support.Error.info> ASSIGN /* := */

%right ARROW
%left LT LTEQ GT GTEQ 
%left EQ NEQ ASSIGN
%left MOD
%left PLUS MINUS
%left STAR SLASH
%nonassoc TILDE PRINT REF BANG RAISE

%type < Syntax.ttm > toplevel

%start toplevel

%%

/* Main body of the parser definition */
   
toplevel: term EOF                             { $1 }

typ0 :
    UNIT                                       { TpTup [] }
  | VAR                                        { TpBase ($1.v) }
  | LPAREN typ RPAREN                          { $2 }
    
typtup :
    typ0 typls                                  { TpTup ($1 :: $2) }

typls : 
  | STAR typ0                                   { [$2] }
  | STAR typ0 typls                             { $2 :: $3 }

typ : 
    typ0                                       { $1 }
  | typ ARROW typ                              { TpFun ($1, $3) }
  | typtup                                     { $1 }
  | REF typ                                    { TpRef ($2) }

ttmBool :
    TRUE                                       { TtmBool true }
  | FALSE                                      { TtmBool false }

ttmInt :
    INTV                                       { TtmInt $1.v }

ttmString :
    STRINGV                                    { TtmStr $1.v }

ttmConst :
    ttmBool                                    { $1 }
  | ttmInt                                     { $1 }
  | ttmString                                  { $1 }

ttm0 :
    ttmConst                                   { $1 }
  | VAR                                        { TtmVar $1.v }
  | LPAREN term RPAREN                         { $2 }
  | LPAREN term COLON typ RPAREN               { TtmAsc ($2, $4) }
  | ttm0 DOT INTV                              { TtmPro ($1, $3.v) }
  | LPAREN ttmTup RPAREN                       { TtmTup ($2) }

ttmOp :
    term PLUS term                             { TtmOp ("+", [$1; $3]) }
  | term MINUS term                            { TtmOp ("-", [$1; $3]) }
  | term STAR term                             { TtmOp ("*", [$1; $3]) }
  | term SLASH term                            { TtmOp ("/", [$1; $3]) }
  | term MOD term                              { TtmOp ("mod", [$1; $3]) }
  | term EQ term                               { TtmOp ("=", [$1; $3]) }
  | term NEQ term                              { TtmOp ("<>", [$1; $3]) }
  | term LT term                               { TtmOp ("<", [$1; $3]) }
  | term LTEQ term                             { TtmOp ("<=", [$1; $3]) }
  | term GT term                               { TtmOp (">", [$1; $3]) }
  | term GTEQ term                             { TtmOp (">=", [$1; $3]) }
  | TILDE term                                 { TtmOp ("~", [$2]) }
  | PRINT term                                 { TtmOp ("print", [$2]) }
  | REF term                                   { TtmRef ($2) }
  | RAISE term                                 { TtmRaise ($2) }
  | term ASSIGN term                           { TtmAssign ($1, $3) }
  | BANG term                                  { TtmDeref ($2) }
 
ttmTup :
    /* empty */                                { [] }
  | term tms                                   { $1 :: $2 }

tms :
    /* empty */                                { [] }
  | COMMA term tms                             { $2 :: $3 }

term :
  | ttmOp                                      { $1 }
  | apptm                                      { $1 }
  | LAMBDA LPAREN VAR COLON typ RPAREN DARROW term       
      { TtmLam ($3.v, $5, $8) }
  | IF term THEN term ELSE term                { TtmIf ($2, $4, $6) }
  | LET VAR EQ term IN term                    { TtmLet ($2.v, $4, $6) }
  | LETREC VAR COLON typ EQ term IN term       { TtmLetrec ($2.v, $4, $6, $8) }
  | FIX term                                   { TtmFix ($2) }
  | TRY term WITH clauses                      { TtmTry ($2, $4) }

clause :
  | term DARROW term                           { ($1, $3) }

clauses : 
  | clause clausesopt                          { $1::$2 }

clausesopt:
  | /* empty */                                { [] }
  | BAR clause clauses                         { $2::$3 }

/* application */
apptm : 
    ttm0                                        { $1 }
  | apptm ttm0                                  { TtmApp ($1, $2) }















