(***********************************************
 *                                             *
 *              CS520 Fall 2006                *
 *           Programming Assignment            *
 *         Computer Science Department         *
 *             Boston University               *
 *                                             *
 ***********************************************)

open Format
open Support.Error
open Support.Pervasive

(* Abstract Syntax of types *)
type stp =
    TpBase of string
  | TpFun of stp * stp
  | TpTup of stp list
  | TpExn (* exception type *)
  | TpRef of stp (* reference type *)    
    
type ttm =
    TtmBool of bool
  | TtmInt of int
  | TtmStr of string
  | TtmVar of string
  | TtmIf of ttm * ttm * ttm
  | TtmOp of string * (ttm list)
  | TtmLam of string * stp * ttm
  | TtmApp of ttm * ttm
  | TtmLet of string * ttm * ttm
  | TtmLetrec of string * stp * ttm * ttm
  | TtmTup of ttm list
  | TtmPro of ttm * int
  | TtmFix of ttm
  | TtmAsc of ttm * stp
  | TtmRef of ttm (* reference *)
  | TtmAssign of ttm * ttm (* assignment *)
  | TtmDeref of ttm (* de-reference *)
  | TtmLoc of int (* location *)
  | TtmRaise of ttm (* raise *)
  | TtmTry of ttm * (ttm * ttm) list (* try ... with ... *)

let rec tp2str tp = 
  match tp with
    TpBase s -> "TpBase \"" ^ s ^ "\""
  | TpFun (tp1, tp2) -> "TpFun (" ^ (tp2str tp1) ^ ", " ^ (tp2str tp2) ^ ")"
  | TpTup (tps) -> "TpTup [" ^ (tps2str tps) ^ "]"
  | TpRef (tp1) -> "TpRef (" ^ (tp2str tp1) ^ ")"
  | TpExn -> "TpExn"

and tps2str tps = 
  match tps with
    [] -> ""
  | tp::tps -> (tp2str tp) ^ "," ^ (tps2str tps)

let rec indent i = if i = 0 then "" else " " ^ (indent (i-1))

let rec tm2str0 i t = 
  match t with
    TtmVar v -> (indent i) ^ "TtmVar \"" ^ v ^ "\""
  | TtmLam (v, tp, t') ->
      (indent i) ^ "TtmLam (\"" ^ v ^ "\", " ^ (tp2str tp) ^ ",\n" 
       ^ (tm2str0 (i+8) t') ^ ")"
  | TtmApp (t1, t2) ->
       (indent i) ^ "TtmApp (\n" 
                  ^ (tm2str0 (i+8) t1) ^ ",\n" 
                  ^ (tm2str0 (i+8) t2) ^ ")"
  | TtmBool b -> (indent i) ^ "TtmBool " ^ (if b then "\"true\"" else "\"false\"")
  | TtmStr s -> (indent i) ^ "TtmStr \"" ^ s ^ "\""
  | TtmInt j -> ((indent i) ^ "TtmInt " ^ (string_of_int j))
  | TtmOp (op, args) -> 
       (indent i) ^ "TtmOp (\"" ^ op ^ "\",\n" ^ 
       (indent (i+7)) ^ "[\n" ^ (tms2str0 (i+8) args) ^ "])"
  | TtmIf (t1, t2, t3) -> (indent i) ^ "TtmIf (\n" 
                                     ^ (tm2str0 (i+7) t1) ^ ",\n" 
                                     ^ (tm2str0 (i+7) t2) ^ ",\n"
                                     ^ (tm2str0 (i+7) t3) ^ ")"
  | TtmLet (v, t1, t2) -> (indent i) ^ "TtmLet (\"" ^ v ^ "\",\n" 
                                     ^ (tm2str0 (i+8) t1) ^ ",\n"
                                     ^ (tm2str0 (i+8) t2) ^ ")"
  | TtmLetrec (v, tp, t1, t2) -> (indent i) ^ "TtmLetrec (\"" ^ v ^ "\"," ^ (tp2str tp) ^ ",\n" 
                                            ^ (tm2str0 (i+11) t1) ^ ",\n"
                                            ^ (tm2str0 (i+11) t2) ^ ")"
  | TtmTup tms -> (indent i) ^ "TtmTup [\n" 
                             ^ (tms2str0 (i+8) tms) ^ "]"
  | TtmPro (t, j) -> (indent i) ^ "TtmPro (\n" ^ (tm2str0 (i+8) t) ^ ", " 
                     ^ (string_of_int j) ^ ")"
  | TtmFix (t) -> (indent i) ^ "TtmFix (\n" 
                             ^ (tm2str0 (i+8) t) ^ ")"
  | TtmAsc (tm, tp) -> (indent i) ^ "TtmAsc (\n" 
                                  ^ (tm2str0 (i+8) tm) ^ ", " ^ (tp2str tp) ^ ")"
  | TtmRef (t1) -> (indent i) ^ "TtmRef (\n"
                             ^ (tm2str0 (i+8) t1) ^ ")"
  | TtmAssign (t1, t2) -> 
       (indent i) ^ "TtmAssign (\n" 
                  ^ (tm2str0 (i+12) t1) ^ ",\n" 
                  ^ (tm2str0 (i+12) t2) ^ ")"
  | TtmDeref (t1) -> (indent i) ^ "TtmDeRef (\n"
                                ^ (tm2str0 (i+10) t1) ^ ")"
  | TtmRaise (s) -> (indent i) ^ "TtmRaise (" ^ (tm2str0 0 s) ^ "\")"
  | TtmLoc (j) -> (indent i) ^ "TtmLoc " ^ (string_of_int j)
  | TtmTry (t1, cls) -> (indent i) ^ "TtmTry (\n" 
                                   ^ (tm2str0 (i+9) t1) ^ ",\n"
                                   ^ (indent (i+9)) ^ "[\n"
                                   ^ (cls2str0 (i+9) cls) ^ "])"

and tms2str0 i tms = 
  match tms with
    [] -> (indent (i-1))
  | tm::tms -> (tm2str0 i tm) ^ ",\n" ^ (tms2str0 i tms)

and cls2str0 i cls =
  match cls with
    [] -> ""
  | (exn,hdl)::cls1 -> (tm2str0 (i+1) exn) ^ "\n"
                     ^ (indent (i+1)) ^ " => \n" 
                     ^ (tm2str0 (i+1) hdl) ^ ",\n" ^ (cls2str0 i cls1)

let rec prettytm2str t = tm2str0 0 t

let printtm t = pr ((prettytm2str t) ^ "\n");










