(***********************************************
 *                                             *
 *              CS520 Fall 2006                *
 *           Programming Assignment            *
 *         Computer Science Department         *
 *             Boston University               *
 *                                             *
 ***********************************************)

(* module Syntax: syntax trees and associated support functions *)

open Support.Pervasive
open Support.Error

(* Abstract Syntax of types *)
type stp =
    TpBase of string
  | TpFun of stp * stp
  | TpTup of stp list
  | TpExn (* exception type *)
  | TpRef of stp (* reference type *)    

(* Abstract Syntax Tree (AST) definitions *)
type ttm =
    TtmBool of bool
  | TtmInt of int
  | TtmStr of string
  | TtmVar of string
  | TtmIf of ttm * ttm * ttm
  | TtmOp of string * (ttm list)
  | TtmLam of string * stp * ttm
  | TtmApp of ttm * ttm
  | TtmLet of string * ttm * ttm
  | TtmLetrec of string * stp * ttm * ttm
  | TtmTup of ttm list
  | TtmPro of ttm * int
  | TtmFix of ttm
  | TtmAsc of ttm * stp
  | TtmRef of ttm (* reference *)
  | TtmAssign of ttm * ttm (* assignment *)
  | TtmDeref of ttm (* de-reference *)
  | TtmLoc of int (* location *)
  | TtmRaise of ttm (* raise *)
  | TtmTry of ttm * (ttm * ttm) list (* try ... with ... *)

(* Printing *)
val printtm: ttm -> unit



