function [H, H_deriv] = RBF( X, Sigma, varargin )
	% compute the H matrix for RBF representation
	%   X: data metrix nData x d, each row is a data point
	%   Sigma: 1 x nCluster or 1 x 1
	%   varargin: cluster matrix
	%   H: nxm matrix, each row is the RBF basis functiosn for a point of X

	if nargin < 3
		C = X;
	else
		C = varargin{1};
	end

	n = size(X, 1);
	m = size(C, 1);
	H = zeros(n, m);
	H_deriv = H;

	if isscalar(Sigma)
		Sigma = Sigma * ones(1, m);
	end
	if ~isrow(Sigma), Sigma = Sigma'; end

	for j = 1:m
		Xdiff = bsxfun(@minus, X, C(j, :));
		H(:, j) = -diag(Xdiff*Xdiff')/Sigma(j);
	end
	H = exp(H);
	H_deriv = bsxfun(@rdivide, H, Sigma);

end
