function f = f_RBF( X, C, Sigma )
	% comput the f_RBF component for X, given centers C
	%   Detailed explanation goes here

	n = size(X, 1);
	m = size(C, 1);
	f = zeros(n, m);
	if isscalar(Sigma), Sigma = Sigma * ones(1, m); end

	for i = 1 : n
		v = bsxfun(@minus, X(i, :), C);
		f(i, :) = -diag(v*v');
	end
	f = exp(bsxfun(@rdivide, f, Sigma));
end
