function opts = get_opts(dataset, seqName, varargin)
	% function opts = get_opts(inargs)
	% initialize opts structure from input (key-value pairs)
	%
	% Kun He, June 2016
	
	ip = inputParser;

	% dataset = 'libsvm';
	% seqName = 'wine';
	% seqName = 'iris';
	% seqName = 'glass';
	% seqName = 'segment';
	%
	% dataset = 'UCI';
	% seqName = 'pima';
	% seqName = 'wdbc';
	% seqName = 'liver';
	% seqName = 'ionosphere';
	
	ip.addRequired('dataset', @isstr);
	ip.addRequired('seqName', @isstr);

	ip.addParamValue('cvfolds', 10, @isscalar);
	ip.addParamValue('parafolds', 5, @isscalar);

	ip.addParamValue('scale', 1, @isscalar);
	ip.addParamValue('niter', 5, @isscalar);
% 	ip.addParamValue('kNN', 2, @isscalar);
	ip.addParamValue('lambda', 0.1, @isscalar);
	ip.addParamValue('sz', repmat(0.1, [1 5]), @isscalar);

	ip.addParamValue('sigmas', 2.^(-5:3), @isscalar);
	ip.addParamValue('gammas', 1.5.^(-4:1), @isscalar);

	ip.addParamValue('localdir', './cachedir/', @isscalar);

	ip.parse(dataset, seqName, varargin{:});
	opts = ip.Results;


	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	% dirs
	%
	if ~exist(opts.localdir), mkdir(opts.localdir); end


	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	% assertions
	%
	assert(numel(opts.sz) >= opts.niter);

end
