function gradF = gradDist_RBF_Euclid(label, Y)
% function for computing gradient of the Euclidean loss
%   Y: nSmp x K


nSmp = length(label);
gradY = Y; % nSmp x K
gradF = Y;
for iSmp = 1 : nSmp
    % compute first derivatives of Y w.r.t. F
    diagY = diag(Y(iSmp,:));
    outerY = Y(iSmp,:)' * Y(iSmp,:);
    dYf1 = diagY - outerY;
    % compute gradY
    gradY(iSmp,label(iSmp)) = gradF(iSmp,label(iSmp)) - 1;
    % compute gradF
    gradF(iSmp,:) = gradY(iSmp,:) * dYf1;
end

end

