/*
* mex_df1_RBF.cc: compute first derivative of F using RBF representation
*
* version: based on Matlab function: gradVol_RBF_nips
*
* This is a MEX-file for MATLAB
*/

#include "mex.h"
#include <math.h>
#include <numeric>
#include <algorithm>
//#include <random>
#include <vector>
#include <valarray>
//#include <inttypes.h>
//#include <Eigen/Dense>
#include "./Eigen/Dense"
using namespace Eigen;


//#ifdef _WIN64
	//typedef unsigned _int64 uint64_t;
//#endif

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
	if(nrhs != 3)
		mexErrMsgTxt("Usage: grad = mex_df1_RBF(Smp, Alpha, RBF)");
	// Smp: d x nSmp
	// Alpha: K x nSmp
	// RBF: nSmp x nSmp

	int K, d, nSmp, i, j;	
	double *arraySmp, *arrayAlpha, *arrayRBF;	
	
	// input
	arraySmp = static_cast<double*>(mxGetData(prhs[0]));	
	d = mxGetM(prhs[0]);	
	nSmp = mxGetN(prhs[0]);
	arrayAlpha = static_cast<double*>(mxGetData(prhs[1])); // K*nSmp
	K = mxGetM(prhs[1]);
	arrayRBF = static_cast<double*>(mxGetData(prhs[2]));
	
	MatrixXd Smp = Map<MatrixXd>(arraySmp, d, nSmp);
	MatrixXd Alpha = Map<MatrixXd>(arrayAlpha, K, nSmp);	
	MatrixXd RBF = Map<MatrixXd>(arrayRBF,nSmp,nSmp);

	// output
	double *df1;
	plhs[0] = mxCreateDoubleMatrix(K, d*nSmp, mxREAL);
	df1 = static_cast<double*>(mxGetPr(plhs[0]));	
	MatrixXd mat_df1(K,d*nSmp);
	
	// compute first derivative	
	VectorXd vecOnes = MatrixXd::Ones(nSmp,1); 
	VectorXd pt(nSmp);
	for (i=0;i<nSmp;i++){			
		pt = RBF.col(i);
		for (j=0;j<d;j++)
			mat_df1.col(d*i+j)=2* Alpha * pt.cwiseProduct( Smp.row(j).transpose()-Smp(j,i)*vecOnes );			
	}

	
	Map<MatrixXd>(df1, K, d*nSmp) = mat_df1;

}

	

