/*
* mex_df2_RBF_fast.cc: compute second derivative of F using RBF representation
*
* version: based on Matlab function: gradVol_RBF_nips_fast3
*
* This is a MEX-file for MATLAB
*/

#include "mex.h"
#include <math.h>
#include <numeric>
#include <algorithm>
//#include <random>
#include <vector>
#include <valarray>
//#include <inttypes.h>
#include <Eigen/Dense>
//#include "./Eigen/Dense"
using namespace Eigen;


//#ifdef _WIN64
	//typedef unsigned _int64 uint64_t;
//#endif

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
	if(nrhs != 3)
		mexErrMsgTxt("Usage: grad = mex_GradVolGraph_Multi_win(DX, Alpha_RBF_Sigma, Alpha_RBF)");
	// DX: nSmp x d
	// Alpha_RBF_Sigma: nSmp x K
	// Alpha_RBF: K x 1	

	int K, d, nSmp, j1, j2, l;	
	double *arrayDX, *arrayAlpha_S, *arrayAlpha;	
	
	// input
	arrayDX = static_cast<double*>(mxGetData(prhs[0]));	
	nSmp = mxGetM(prhs[0]);	
	d = mxGetN(prhs[0]);
	arrayAlpha_S = static_cast<double*>(mxGetData(prhs[1])); // K*nSmp
	K = mxGetN(prhs[1]);
	arrayAlpha = static_cast<double*>(mxGetData(prhs[2]));	

	MatrixXd DX = Map<MatrixXd>(arrayDX, nSmp, d);
	MatrixXd Alpha_RBF_Sigma = Map<MatrixXd>(arrayAlpha_S, nSmp, K);	
	VectorXd Alpha_RBF = Map<VectorXd>(arrayAlpha,K);	

	// output
	double *df2;
	//K = nSmp;
	plhs[0] = mxCreateDoubleMatrix(K, d*d, mxREAL);
	//plhs[0] = mxCreateDoubleMatrix(K,1,mxREAL);
	df2 = static_cast<double*>(mxGetPr(plhs[0]));	
	MatrixXd mat_df2(K,d*d);
	//MatrixXd mat_df2(K,1);
	

	// compute second derivative	
	VectorXd pt(nSmp);
	VectorXd pt0(nSmp);
	VectorXd pt1(nSmp);
	MatrixXd DX_j1(K,nSmp); // K x nSmp
	VectorXd val(K);
	for (j1=0;j1<d;j1++){
		for (l=0;l<K;l++){
			DX_j1.row(l) = ( DX.col(j1).cwiseProduct(Alpha_RBF_Sigma.col(l)) ).transpose();
		}

		for (j2=0;j2<j1;j2++){
			val = DX_j1*DX.col(j2);
			mat_df2.col(d*j1+j2) = val;
			mat_df2.col(d*j2+j1) = val;							
		}
		
		mat_df2.col(d*j1+j1) = DX_j1*DX.col(j1) - Alpha_RBF;
		
	}
	 
	Map<MatrixXd>(df2, K, d*d) = mat_df2;
	//Map<MatrixXd>(df2, K, 1) = pt;

}

	

